/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class AreaBlockSearch
implements Runnable {
    private Player player;
    private Location location;
    private int type;
    private int size;
    private Connection conn = null;
    private String table;

    AreaBlockSearch(Connection conn, Player player, int type, int size, String table) {
        this.player = player;
        this.location = player.getLocation();
        this.type = type;
        this.size = size;
        this.conn = conn;
        this.table = table;
    }

    @Override
    public void run() {
        boolean hist = false;
        Statement ps = null;
        ResultSet rs = null;
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd HH:mm:ss");
        try {
            try {
                this.conn.setAutoCommit(false);
                ps = this.conn.prepareStatement("SELECT * FROM `" + this.table + "` INNER JOIN `lb-players` USING (`playerid`) WHERE (type = ? or replaced = ?) and y > ? and y < ? and x > ? and x < ? and z > ? and z < ? order by date desc limit 10", 1);
                ps.setInt(1, this.type);
                ps.setInt(2, this.type);
                ps.setInt(3, this.location.getBlockY() - this.size);
                ps.setInt(4, this.location.getBlockY() + this.size);
                ps.setInt(5, this.location.getBlockX() - this.size);
                ps.setInt(6, this.location.getBlockX() + this.size);
                ps.setInt(7, this.location.getBlockZ() - this.size);
                ps.setInt(8, this.location.getBlockZ() + this.size);
                rs = ps.executeQuery();
                this.player.sendMessage(ChatColor.DARK_AQUA + "Block history for " + this.getMaterialName(this.type) + " within " + this.size + " blocks of  " + this.location.getBlockX() + ", " + this.location.getBlockY() + ", " + this.location.getBlockZ() + ": ");
                while (rs.next()) {
                    String msg = String.valueOf(formatter.format(rs.getTimestamp("date"))) + " " + rs.getString("playername") + " (" + rs.getInt("x") + ", " + rs.getInt("y") + ", " + rs.getInt("z") + ") ";
                    msg = rs.getInt("type") == 0 ? String.valueOf(msg) + "destroyed " + this.getMaterialName(rs.getInt("replaced")) : (rs.getInt("replaced") == 0 ? String.valueOf(msg) + "created " + this.getMaterialName(rs.getInt("type")) : String.valueOf(msg) + "replaced " + this.getMaterialName(rs.getInt("replaced")) + " with " + this.getMaterialName(rs.getInt("type")));
                    this.player.sendMessage(ChatColor.GOLD + msg);
                    hist = true;
                }
                if (!hist) {
                    this.player.sendMessage(ChatColor.DARK_AQUA + "None.");
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock AreaBlockSearch] SQL exception", ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex2) {
                    LogBlock.log.log(Level.SEVERE, "[LogBlock AreaBlockSearch] SQL exception on close", ex2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                LogBlock.log.log(Level.SEVERE, "[LogBlock AreaBlockSearch] SQL exception on close", ex);
            }
        }
    }

    private String getMaterialName(int type) {
        return Material.getMaterial((int)type).toString().toLowerCase().replace('_', ' ');
    }
}

